//=============================================================================
// This trigger, when triggered, destroys the actor class that triggered it
// this can be used by being touched.
//=============================================================================
class DestroyObjectTrigger extends Trigger;

var() sound TriggeredSound;

//=============================================================================
// AI related functions

function Trigger(Actor Other, Pawn EventInstigator)
{
 local Actor A;

 if (IsRelevant(Other))
 {
  if( Event != '' )
  {
   foreach AllActors( class 'Actor', A, Event )
   {
    A.Trigger( Other, EventInstigator );
   }
  }
    PlaySound(TriggeredSound);
    Other.Destroy();
    log("Succesful Destruction of proximity class!");
 }
}

function Touch(Actor Other)
{
 local Actor A;

 if (IsRelevant(Other))
 {
  if( Event != '' )
  {
   foreach AllActors( class 'Actor', A, Event )
   {
    A.Trigger( Other, Other.Instigator );
   }
  }
    PlaySound(TriggeredSound);
    Other.Destroy();
    log("Succesful Destruction of proximity class!");
 }
}

defaultproperties
{
     TriggerType=TT_ClassProximity
     Texture=Texture'Engine.S_Trigger'
}
